**Radical Micro** - пакет плагинов для добавления микроданных и микроразметки на сайт.

Из коробки плагин имеет добавлять следующую микроразметку:

### Schema.org
- Organization
- Website
- Breadcrumb List
- Article
- NewsArticle
- Product
- Recipe

### Meta
- Open Graph (OG)
- Twitter

Разметка Schema.org добавляется в формате `JSON-LD`.
Meta разметка добавляется в тэге `<meta>`.

### Логика работы

Логика работы проста - управляющий плагин собирает данные от плагинов-провайдеров и на основе этих данных встраивает разметку на сайт. Расширить работу плагина можно, добавив новые плагины провайдеры, а также другие поддерживаемые типы микроразметки и микроданных.

### Пакет включает в себя

- управляющий плагин, который занимается сбором данных от плагинов провайдеров и добавляет разметку на сайт.
- плагин для YOOtheme Pro, содержащий в себе 2 элемента для добавления каждого типа микроданных.
- плагин-провайдер для компонента стандартных материалов Joomla.
- плагин-провайдер для меню
- плагин-провайдер для значений по умолчанию
- плагин-провайдер для автоматической генерации изображений (о нем хотелось бы написать больше, но для этого не хватит места, лучше стоит попробовать)

### Особенности работы

Плагин может встраивать разметку перед тегом `<body>` или перед тегом `<head>` в зависимости от настроек.

Также плагин содержит настройку, которая позволяет не добавлять сгенерированную разметку на сайт, если в теле страницы уже присутствует разметка соответствующего типа.

### Для разработчиков

#### Создание расширяющего плагина

Плагин RadicalMicro можно расширять своими плагинами. Тип расширяющего плагина `radicalmicro`. В нем можно подключать свои типы для коллекций Schema.org и Meta, чтобы они подгружались в любых других местах (например, в плагине материалов), а также передавать свои данные из компонентов.

Коллекции в плагине RadicalMicro - классы, которые обрабатывают переданные им данные и формируют необходимые массивы для разметок. Каждый из них имеет всего 2 метода `execute` и `getConfig`, а также переменная `$uid` - уникальная для каждого типа коллекции. Эти файлы могут лежать в любой отдельной папке Вашего плагина, но их нужно разделить по типу - `meta` (микроразметка страницы), `schema` (schema.org контента страницы) и `schema_extra` (дополнительная разметка schema.org).

Добавление коллекций Schema.org и Meta (`$path` - абcолютный путь до папки, где лежат необходимые коллекции) необходимо делать в методе `onRadicalMicroRegisterTypes`:

```
use RadicalMicro\Helpers\PathHelper;

PathHelper::getInstance()->register($path, 'schema');
PathHelper::getInstance()->register($path, 'schema_extra');
PathHelper::getInstance()->register($path, 'meta');
```

Если коллекции добавить таким образом, они будут подгружены во все места, где предоставляется их выбор, например, в плагине Стандартных материалов или плагине Yootheme Pro.

Добавление своих данных в существующие коллекции необходимо делать в методе `onRadicalmicroProvider:`

```
use RadicalMicro\Helpers\Tree\SchemaHelper;
use RadicalMicro\Helpers\Tree\OGHelper;

$schemaData = TypesHelper::execute('schema', 'schema_collection_name', ['name' => 'John'], $priority);
SchemaHelper::getInstance()->addChild('root', 'collection_name', ['name' => 'John'], $priority);

$ogData = TypesHelper::execute('meta', 'meta_collection_name', ['name' => 'John'], $priority);
OGHelper::getInstance()->addChild('root', 'meta_collection_name', ['name' => 'John'], $priority);
```

Здесь `$priopity` - это приоритет переданных данных. Об этом чуть ниже.

Пример простого расширяющего плагина для RadicalMicro можно посмотреть [здесь](https://github.com/fiction13/plg_radicalmicro_example).

#### Переопределение данных в шаблоне

Плагин позволяет переопределить данные любого типа любой коллекции, которые ему передали, в любом месте шаблона с помощью системы приоритетов. Для этого нам пригодятся упомянутый выше `$uid` - уникальный идентификатор для каждой коллекции (существующие индентификаторы можно посмотреть в файлах плагина `/plugins/system/radicalmicro/src/Types/Collections/..`).

Все данные плагинов-провайдеров передаются с приоритетом `0.5`, данные от плагина-провайдера Меню передаются с приоритетом `0.9` (поэтому он перезаписывает данные любого плагина). Поэтому передав плагину данные с приоритетом выше `0.9` можно переписать любые данные.

Например, если в любом месте шаблона или вывода любого компонента прописать следующее:

```
use RadicalMicro\Helpers\Tree\OGHelper;

$data = [
    'uid'         => 'radicalmicro.meta.twitter',
    'title'       => 'Новый заголовок',
    'description' => 'Новое описание',
    'image'       => 'Новое изображение',
    'site'        => 'Новая ссылка на сайт'
];
        
$ogData = TypesHelper::execute('meta', 'twitter', $data, 1);
OGHelper::getInstance()->addChild('root', $ogData);
```

То вся разметка Twitter в конечном итоге будет сформирована с новыми данными.

#### Заключение

Подводя итого, хочется отметить, что плагин создавался максимально расширяемым и удобным (насколько это возможно для плагина). Поэтому берите молотки и напильники в руки, чтобы помогать развивать систему дальше.

Развлекайтесь ;-)